﻿//////////////////////////////////////////////
// LambdaTask.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkTasks
#include "../Dll/DllDefines.h"

#include "Task.h"

// Standards
#include <functional>

/// Class ------------------------------------

namespace nkTasks
{
	class DLL_TASKS_EXPORT LambdaTask : public Task
	{			
		public :
		
			// Constructor, destructor
			LambdaTask () noexcept ;
			LambdaTask (std::function<void ()> asyncWorkFunction) noexcept ;
			virtual ~LambdaTask () ;

			// Setters
			void setAsyncWorkFunction (std::function<void ()> function) ;

			// Implement base methods
			virtual void onAsyncWork () override ;

		private :
		
			// Attributes
			// Used callbacks
			std::function<void ()> _asyncWorkFunction ;
	} ;
}